/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.command.executor;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MinimumPartySizePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.preset.RentalBattlePreset;
import kiwiapollo.cobblemontrainerbattle.command.executor.RentalPokemonStatusPrinter;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class CloneRentalPokemonProvider
implements Command<class_2168> {
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (!this.hasMinimumPartySize(player)) {
                player.method_43496((class_2561)class_2561.method_43469((String)"command.cobblemontrainerbattle.error.rentalpokemon.player_minimum_party_size", (Object[])new Object[]{RentalBattlePreset.PARTY_SIZE}).method_27692(class_124.field_1061));
                return 0;
            }
            PlayerPartyStore original = Cobblemon.INSTANCE.getStorage().getParty(player);
            PartyStore clone = this.toClone((PartyStore)original);
            PartyStore rental = this.toRental(clone);
            BattleContextStorage.getInstance().getOrCreate(player.method_5667()).setRentalPokemon(rental);
            new RentalPokemonStatusPrinter().run(context);
            return 1;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }

    private PartyStore toClone(PartyStore party) {
        PartyStore clone = new PartyStore(UUID.randomUUID());
        party.toGappyList().stream().filter(Objects::nonNull).forEach(pokemon -> clone.add(pokemon.clone(true, null)));
        return clone;
    }

    private PartyStore toRental(PartyStore party) {
        PartyStore rental = new PartyStore(UUID.randomUUID());
        party.toGappyList().stream().filter(Objects::nonNull).toList().subList(0, RentalBattlePreset.PARTY_SIZE).forEach(arg_0 -> ((PartyStore)rental).add(arg_0));
        rental.toGappyList().forEach(pokemon -> pokemon.setLevel(RentalBattlePreset.LEVEL));
        return rental;
    }

    private boolean hasMinimumPartySize(class_3222 player) {
        MinimumPartySizePredicate.ValuePredicate minimumPartySizePredicate = new MinimumPartySizePredicate.ValuePredicate(RentalBattlePreset.PARTY_SIZE);
        PlayerPartyStore original = Cobblemon.INSTANCE.getStorage().getParty(player);
        return minimumPartySizePredicate.test(original.occupied());
    }
}

